ORCA/M Asm65816 2.1.0

0001 B300              *******************************************************************************
0002 B300              *
0003 B300              *        Name:  os_event
0004 B300              *
0005 B300              * Description:  Notify anyone in the os_event_queue who wants this event that
0006 B300              *               it has occured.  The A, X, and Y registers on the stack will be
0007 B300              *               passed to the notify_procs in the respective registers.
0008 B300              *
0009 B300              *      Author:  Bryan Atsatt
0010 B300              *     Created:  Nov 17, 1988
0011 B300              *    Modified:  Dec 1, 1988     BPA     set direct page to zero before
0012 B300              *                                       calling notify_proc.
0013 B300              *               Jan 16, 1989    BPA     Changed code storage to local variable
0014 B300              *                                       and saved link_pointer across call to
0015 B300              *                                       notify_proc.
0016 B300              *               Sep 13, 1989    CAF     preserved the value of 'code' across the
0017 B300              *                                       call to notify_proc.
0018 B300              *               Sep 15, 1989    CAF     moved the code that pushes 'code' onto the
0019 B300              *                                       stack to before the a,x,y registers are
0020 B300              *                                       loaded (I was trashing A before)
0021 B300              *               Sep 18, 1989    CAF     fixed stack relative offsets when loading
0022 B300              *                                       the a,x,y registers (I pushed 4 bytes onto
0023 B300              *                                       the stack)
0024 B300              *
0025 B300              *       Entry:  jsl $1fcc4
0026 B300              *
0027 B300              *       Input:  A = low word of event code.
0028 B300              *               X = high word of event code.
0029 B300              *               Y = undefined.
0030 B300              *               P = nvmxdizc
0031 B300              *                   ..000...
0032 B300              *
0033 B300              *               Stack:  
0034 B300              *                       |   previous contents   |
0035 B300              *                       |_______________________|
0036 B300              *                       |  A register parameter | word
0037 B300              *                       |_______________________|
0038 B300              *                       |  X register parameter | word
0039 B300              *                       |_______________________|
0040 B300              *                       |  Y register parameter | word
0041 B300              *                       |_______________________|
0042 B300              *                       |                       | 3 bytes
0043 B300              *                       |     return address    |
0044 B300              *                       |_______________________|
0045 B300              *                       |                       | <- SP
0046 B300              *
0047 B300              *      Output:  A = undefined
0048 B300              *               X = undefined
0049 B300              *               Y = undefined
0050 B300              *               P = nvmxdizc
0051 B300              *                   ..000...
0052 B300              *
0053 B300              *               Stack:
0054 B300              *                       |   previous contents   |
0055 B300              *                       |_______________________|
0056 B300              *                       |                       | <- SP
0057 B300              *
0058 B300              *        Exit:  rtl
0059 B300              *
0060 B300              *        Uses:  event_queue
0061 B300              *               s_temp1
0062 B300              *               s_temp2
0063 B300              *
0064 B300              * Copyright Apple Computer, Inc. 1988  All rights reserved.
0065 B300              *******************************************************************************
0066 B300
0067 B300              os_event proc 
0068 B300
0069 B300              link_pointer equ   s_temp1              ;Pointer to queue header temp.
0070 B300
0071 B300              *
0072 B300              * First set environment and save off the event code...
0073 B300              *
0074 B300 8B                    phb                            ;Save data bank.
0075 B301 4B                    phk                            ;Set to our code bank.
0076 B302 AB                    plb   
0077 B303
0078 B303 8D 95 B3              sta   code                     ;Save low word.
0079 B306 8E 97 B3              stx   code+2                   ;Save high word.
0080 B309              *
0081 B309              * Get pointer to next handler (if any) from our header...
0082 B309              *
0083 B309 AD F1 F3              lda   event_queue              ;Get low word.
0084 B30C AE F3 F3              ldx   event_queue+2            ;Get high word.
0085 B30F              *
0086 B30F              * Save link pointer and exit if nil. Else, add offset to code entry point,
0087 B30F              * and self-modify our jsl address...
0088 B30F              *
0089 B30F 85 D4        queue_loop sta   <link_pointer          ;Set low word of address.
0090 B311 86 D6                 stx   <link_pointer+2          ;Set high word..
0091 B313 05 D6                 ora   <link_pointer+2          ;Nil pointer?
0092 B315 F0 6E                 beq   exit                     ;Yep, so we're done.
0093 B317              *
0094 B317              * Should we call this guy?  If not, skip him...
0095 B317              *
0096 B317 A0 08 00              ldy   #event_flags-event_queue ;Get offset to lo word of flags.
0097 B31A B7 D4                 lda   [<link_pointer],y        ;Get low word of flag.
0098 B31C 2D 95 B3              and   code                     ;Any bits match?
0099 B31F AA                    tax                            ;Save result.
0100 B320 A0 0A 00              ldy   #event_flags-event_queue+2 ;Get offset to hi word of flags.
0101 B323 B7 D4                 lda   [<link_pointer],y        ;Get hi word of flag.
0102 B325 2D 97 B3              and   code+2                   ;Any bits match?
0103 B328 D0 03                 bne   do_it                    ;Yes, so continue.
0104 B32A 9B                    txy                            ;Nope, any in the low word?
0105 B32B F0 4E                 beq   next_link                ;Nope, so skip it.
0106 B32D              *
0107 B32D              * Stuff the event code into the queue header, calculate entry point, load up the
0108 B32D              * registers and jsl to the code entry point...
0109 B32D              *
0110 B32D A0 0E 00     do_it    ldy   #event_code-event_queue+2 ;Point to hi word of event code.
0111 B330 97 D4                 sta   [<link_pointer],y        ;Stuff in header.
0112 B332
0113 B332 8A                    txa                            ;Get low word of code.
0114 B333 A0 0C 00              ldy   #event_code-event_queue  ;Point to lo word of event code.
0115 B336 97 D4                 sta   [<link_pointer],y        ;Stuff in header.
0116 B338
0117 B338 18                    clc                            ;Calculate entry point.
0118 B339 A5 D4                 lda   <link_pointer
0119 B33B A6 D6                 ldx   <link_pointer+2
0120 B33D 69 10 00              adc   #entry_point-event_queue
0121 B340 90 01                 bcc   save_it
0122 B342 E8                    inx   
0123 B343
0124 B343 8D 68 B3     save_it  sta   jsl_address+1            ;Set low word of address.
0125 B346 E2 10                 sep   #x8                      ;Set 8 bit index.
0126 B348 8E 6A B3              stx   jsl_address+3            ;Set high byte of address.
0127 B34B C2 10                 rep   #x8                      ;Restore 16 bit index.
0128 B34D
0129 B34D
0130 B34D AD 95 B3              lda   code                     ; <9/13/89 CAF>
0131 B350 48                    pha                            ; <9/13/89 CAF>
0132 B351 AD 97 B3              lda   code+2                   ; <9/13/89 CAF>
0133 B354 48                    pha                            ; <9/13/89 CAF>
0134 B355
0135 B355 A3 09                 lda   5+4,s                    ;Get Y parameter.
0136 B357 A8                    tay   
0137 B358 A3 0B                 lda   7+4,s                    ;Get X parameter.
0138 B35A AA                    tax   
0139 B35B A3 0D                 lda   9+4,s                    ;Get A parameter.
0140 B35D
0141 B35D D4 D4                 pei   <link_pointer            ;Save pointer.
0142 B35F D4 D6                 pei   <link_pointer+2
0143 B361 0B                    phd                            ;Save direct register.
0144 B362 8B                    phb                            ;Save bank register.
0145 B363 F4 00 00              pea   0000                     ;Set direct register to zero.
0146 B366 2B                    pld   
0147 B367 22 00 00 00  jsl_address jsl   $000000               ;Call handler (SELF-MODIFIED!)
0148 B36B AB                    plb                            ;Restore bank.
0149 B36C 2B                    pld                            ;Restore direct register.
0150 B36D 68                    pla                            ;Restore pointer.
0151 B36E 85 D6                 sta   <link_pointer+2
0152 B370 68                    pla   
0153 B371 85 D4                 sta   <link_pointer
0154 B373
0155 B373 68                    pla                            ; <9/13/89 CAF>
0156 B374 8D 97 B3              sta   code+2                   ; <9/13/89 CAF>
0157 B377 68                    pla                            ; <9/13/89 CAF>
0158 B378 8D 95 B3              sta   code                     ; <9/13/89 CAF>
0159 B37B              *
0160 B37B              * Now load up next link and loop...
0161 B37B              *
0162 B37B A0 02 00     next_link ldy   #0002                   ;Point to high word of link.
0163 B37E B7 D4                 lda   [<link_pointer],y        ;Get high word.
0164 B380 AA                    tax                            ;Put in X.
0165 B381 A7 D4                 lda   [<link_pointer]          ;Get low word.
0166 B383 80 8A                 bra   queue_loop               ;Loop.
0167 B385              *
0168 B385              * We're all done.  Restore data bank, move return address up stack and exit...
0169 B385              *
0170 B385 AB           exit     plb                            ;Restore data bank.
0171 B386
0172 B386 A3 02                 lda   2,s                      ;Move return address up.
0173 B388 83 08                 sta   8,s
0174 B38A A3 01                 lda   1,s                      ;(overlapping)
0175 B38C 83 07                 sta   7,s
0176 B38E 18                    clc                            ;Adjust stack pointer.
0177 B38F 3B                    tsc   
0178 B390 69 06 00              adc   #6
0179 B393 1B                    tcs   
0180 B394 6B                    rtl                            ;Exit.
0181 B395
0182 B395 00 00 00 00  code     DC L:00000000                  ;Space for event code.
0183 B399
0184 B399                       end_proc 
0185 B399                       eject 
0186 B399              *******************************************************************************
0187 B399              *
0188 B399              *        Name:  os_add_queue and os_delete_queue
0189 B399              *
0190 B399              * Description:  Adds/deletes call handler to/from os_event_queue.
0191 B399              *
0192 B399              *      Author:  Bryan Atsatt
0193 B399              *     Created:  Nov 18, 1988
0194 B399              *    Modified:  Jan 4, 1989     BPA     Added logic to count notify_procs with
0195 B399              *                                       volume_change flag set.
0196 B399              *
0197 B399              *       Entry:  jsr
0198 B399              *
0199 B399              *       Input:  A = undefined
0200 B399              *               X = undefined
0201 B399              *               Y = undefined.
0202 B399              *               P = nvmxdizc
0203 B399              *                   ..000...
0204 B399              *
0205 B399              *      Output:  A = error code if error.
0206 B399              *               X = undefined
0207 B399              *               Y = undefined
0208 B399              *               P = nvmxdizc
0209 B399              *                   ..000..0 = no error
0210 B399              *                          1 = error
0211 B399              *
0212 B399              *        Exit:  rts
0213 B399              *
0214 B399              *        Uses:  AddToQueue (misctools)
0215 B399              *               DeleteFromQueue (misctools)
0216 B399              *               set_ptr
0217 B399              *               s_temp1
0218 B399              *               s_temp2
0219 B399              *               s_temp3
0220 B399              *
0221 B399              * Copyright Apple Computer, Inc. 1988  All rights reserved.
0222 B399              *******************************************************************************
0223 B399
0224 B399              os_add_queue proc 
0225 B399
0226 B399              add_del_flag equ   s_temp1              ;Temp equate.
0227 B399
0228 B399 A9 01 00              lda   #$0001                   ;Select add.
0229 B39C 80 03                 bra   do_it
0230 B39E
0231 B39E                       entry os_delete_queue
0232 B39E
0233 B39E A9 FF FF     os_delete_queue lda   #$ffff            ;Select delete.
0234 B3A1 85 D4        do_it    sta   <add_del_flag            ;Save selection.
0235 B3A3              *
0236 B3A3              * Is the pointer nil?
0237 B3A3              *
0238 B3A3 20 AC E3              jsr   set_ptr                  ;Bump pointer to first parm.
0239 B3A6 A7 FC                 lda   [<pb_ptr]                ;Get low word of pointer.
0240 B3A8 AA                    tax                            ;Save it.
0241 B3A9 A0 02 00              ldy   #0002                    ;Point to high word of pointer.
0242 B3AC 17 FC                 ora   [<pb_ptr],y              ;Nil?
0243 B3AE F0 17                 beq   bad_parm                 ;Yep.
0244 B3B0              *
0245 B3B0              * Nope, so push parameters for call...
0246 B3B0              *
0247 B3B0 B7 FC                 lda   [<pb_ptr],y              ;Get high word of pointer.
0248 B3B2
0249 B3B2 48                    pha                            ;Push caller's pointer.
0250 B3B3 DA                    phx   
0251 B3B4 F4 00 00              pea   event_queue>>16          ;Push pointer to our header.
0252 B3B7 F4 F1 F3              pea   event_queue
0253 B3BA              *
0254 B3BA              * Now call either AddToQueue or DeleteFromQueue and exit if error...
0255 B3BA              *
0256 B3BA A5 D4                 lda   <add_del_flag            ;AddToQueue?
0257 B3BC 30 0E                 bmi   delete                   ;Nope.
0258 B3BE
0259 B3BE A2 03 2E 22           _AddToQueue                    ;Yes, do add call.
0260 B3C5 90 0E                 bcc   success                  ;success.
0261 B3C7
0262 B3C7 A9 53 00     bad_parm lda   #parm_range_err          ;Exit with error.
0263 B3CA 38                    sec   
0264 B3CB 60                    rts   
0265 B3CC
0266 B3CC A2 03 2F 22  delete   _DeleteFromQueue               ;Do delete call.
0267 B3D3 B0 F2                 bcs   bad_parm                 ;error ->
0268 B3D5
0269 B3D5              *
0270 B3D5              * We were successful, so exit with carry clear...
0271 B3D5              *
0272 B3D5 60           success  rts                            ; carry is already clear
0273 B3D6
0274 B3D6
0275 B3D6                       end_proc 
0276 B3D6                       eject 
0277 B3D6              *******************************************************************************
0278 B3D6              *
0279 B3D6              *        Name:  set_prefix_33
0280 B3D6              *
0281 B3D6              * Description:  Sets prefix 33, the '@' prefix.
0282 B3D6              *
0283 B3D6              *      Author:  Bryan Atsatt
0284 B3D6              *     Created:  Nov 21, 1988
0285 B3D6              *    Modified:  Nov 30, 1988    BPA     Fixed set_prefix_33 so does not
0286 B3D6              *                                       count trailing zero in length word
0287 B3D6              *               Dec 12, 1988    BPA     Added CLC after string copy.
0288 B3D6              *
0289 B3D6              *       Entry:  jsl
0290 B3D6              *
0291 B3D6              *       Input:  A = low word of pointer to class 1 string
0292 B3D6              *               X = high word of pointer to class 1 string
0293 B3D6              *               Y = undefined.
0294 B3D6              *               P = nvmxdizc
0295 B3D6              *                   ..000...
0296 B3D6              *
0297 B3D6              *      Output:  A = error code if error.
0298 B3D6              *               X = undefined
0299 B3D6              *               Y = undefined
0300 B3D6              *               P = nvmxdizc
0301 B3D6              *                   ..000..0 = no error
0302 B3D6              *                          1 = error
0303 B3D6              *
0304 B3D6              *        Exit:  rtl
0305 B3D6              *
0306 B3D6              *        Uses:  set_ptr
0307 B3D6              *               allocate
0308 B3D6              *               deallocate
0309 B3D6              *               s_temp1
0310 B3D6              *               s_temp2
0311 B3D6              *               m_temp
0312 B3D6              *
0313 B3D6              * Copyright Apple Computer, Inc. 1988  All rights reserved.
0314 B3D6              *******************************************************************************
0315 B3D6
0316 B3D6              set_prefix_33 proc 
0317 B3D6
0318 B3D6              string_ptr equ   s_temp1                ;Temporary equate.
0319 B3D6              buffer_ptr equ   s_temp2                ;Temporary equate.
0320 B3D6
0321 B3D6              *
0322 B3D6              * Set pointer to string...
0323 B3D6              *
0324 B3D6 85 D4                 sta   <string_ptr              ;Set low word of pointer.
0325 B3D8 86 D6                 stx   <string_ptr+2            ;Set high word.
0326 B3DA              *
0327 B3DA              * Allocate memory for new prefix.  Exit if fail...
0328 B3DA              *
0329 B3DA A7 D4                 lda   [<string_ptr]            ;Get length.
0330 B3DC 1A                    inc   a                        ;Bump by two for length word.
0331 B3DD 1A                    inc   a
0332 B3DE 1A                    inc   a                        ;Bump it one for the added zero.
0333 B3DF 22 4C FB 00           jsl   allocate                 ;Allocate memory.
0334 B3E3 B0 36                 bcs   exit                     ;Exit on error.
0335 B3E5              *
0336 B3E5              * Add VP to prefices table, and set buffer_ptr to new buffer...
0337 B3E5              *
0338 B3E5 A9 21 00              lda   #33                      ;Select prefix 33.
0339 B3E8 20 BC E3              jsr   set_pfx                  ;Install new VP.
0340 B3EB
0341 B3EB BF D7 F4 00           lda   >prefices,x              ;Recover low word of VP.
0342 B3EF AA                    tax   
0343 B3F0 22 09 FE 00           jsl   deref2                   ;Dereference VP.
0344 B3F4 86 D8                 stx   <buffer_ptr              ;Save pointer.
0345 B3F6 84 DA                 sty   <buffer_ptr+2
0346 B3F8              *
0347 B3F8              * Deallocate old VP if any...
0348 B3F8              *
0349 B3F8 A4 EE                 ldy   <m_temp+2                ;Was there a VP to deallocate?
0350 B3FA 30 06                 bmi   do_copy                  ;Nope.
0351 B3FC A6 EC                 ldx   <m_temp                  ;Yes, so get rid of it.
0352 B3FE 22 15 FD 00           jsl   deallocate
0353 B402              *
0354 B402              * Now copy the string into the buffer, add a trailing zero and exit...
0355 B402              *
0356 B402 A7 D4        do_copy  lda   [<string_ptr]            ;Get length of string in X.
0357 B404 87 D8                 sta   [<buffer_ptr]            ;Set new length.
0358 B406 AA                    tax                            ;Save length in X.
0359 B407
0360 B407                       longa off                      ;Set 8 bit mode.
0361 B407 E2 20                 sep   #m8
0362 B409
0363 B409 A0 02 00              ldy   #0002                    ;Point to first character.
0364 B40C B7 D4        copy_loop lda   [<string_ptr],y         ;Copy byte.
0365 B40E 97 D8                 sta   [<buffer_ptr],y
0366 B410 C8                    iny                            ;Bump offset.
0367 B411 CA                    dex                            ;Done all?
0368 B412 D0 F8                 bne   copy_loop                ;Nope, so loop.
0369 B414
0370 B414 A9 00                 lda   #00                      ;Add trailing zero.
0371 B416 97 D8                 sta   [<buffer_ptr],y
0372 B418
0373 B418                       longa on                       ;Set 16 bit mode.
0374 B418 C2 20                 rep   #m8
0375 B41A
0376 B41A 18                    clc                            ;No error.
0377 B41B 6B           exit     rtl                            ;Exit.
0378 B41C
0379 B41C                       end_proc 
0380 B41C                       eject 
0381 B41C              *******************************************************************************
0382 B41C              *
0383 B41C              *        Name:  get_std_ref_num
0384 B41C              *
0385 B41C              * Description:  Returns refnum for last file opened for prefix 10,11 or 12.
0386 B41C              *
0387 B41C              *      Author:  Bryan Atsatt
0388 B41C              *     Created:  Feb 8, 1989
0389 B41C              *    Modified:  Feb 8, 1989
0390 B41C              *
0391 B41C              *       Entry:  jsr
0392 B41C              *
0393 B41C              *       Input:  A = undefined
0394 B41C              *               X = undefined
0395 B41C              *               Y = undefined
0396 B41C              *               P = nvmxdizc
0397 B41C              *                   ..000...
0398 B41C              *
0399 B41C              *               std_ref_num             ;table of 3 refnums (0=undefined).
0400 B41C              *
0401 B41C              *      Output:  A = Error code if error.
0402 B41C              *               X = undefined
0403 B41C              *               Y = undefined
0404 B41C              *               P = nvmxdizc
0405 B41C              *                   ..000..0 no error
0406 B41C              *                          1 error
0407 B41C              *
0408 B41C              *        Exit:  rts
0409 B41C              *
0410 B41C              *        Uses:  set_ptr
0411 B41C              *
0412 B41C              * Copyright Apple Computer, Inc. 1988  All rights reserved.
0413 B41C              *******************************************************************************
0414 B41C
0415 B41C              get_std_ref_num proc 
0416 B41C
0417 B41C              *
0418 B41C              * Set up our access to the parameter block...
0419 B41C              *
0420 B41C 20 AC E3              jsr   set_ptr                  ;Set pb_ptr
0421 B41F              *
0422 B41F              * Make sure the prefix requested is 10, 11 or 12...
0423 B41F              *
0424 B41F A2 53 00              ldx   #parm_range_err          ;Assume error.
0425 B422
0426 B422 A0 00 00              ldy   #pblk_37_pfxnum          ;Get offset to prefix.
0427 B425 B7 FC                 lda   [<pb_ptr],y              ;Get the prefix number.
0428 B427 38                    sec                            ;Put in range 0-2.
0429 B428 E9 0A 00              sbc   #10
0430 B42B C9 03 00              cmp   #3                       ;In range?
0431 B42E B0 0A                 bcs   error                    ;Nope.
0432 B430              *
0433 B430              * It is. Make sure the requested ref_num is valid...
0434 B430              *
0435 B430 A2 60 00              ldx   #data_unavail            ;Assume error.
0436 B433
0437 B433 0A                    asl   a                        ;Use as word offset.
0438 B434 A8                    tay   
0439 B435 B9 1B B9              lda   std_ref_num,y            ;Get ref_num. Valid?
0440 B438 D0 03                 bne   valid                    ;Yep.
0441 B43A
0442 B43A 38           error    sec                            ;Nope, so return error.
0443 B43B 8A                    txa   
0444 B43C 60                    rts   
0445 B43D              *
0446 B43D              * It is, so stuff it in the user's parameter block and exit...
0447 B43D              *
0448 B43D A0 02 00     valid    ldy   #pblk_37_refnum          ;Get offset to parm.
0449 B440 97 FC                 sta   [<pb_ptr],y              ;Stuff it.
0450 B442
0451 B442 18                    clc                            ;Indicate no error.
0452 B443 60                    rts                            ;Exit.
0453 B444
0454 B444                       end_proc 
0455 B444                       eject 
0456 B444              *******************************************************************************
0457 B444              *
0458 B444              *        Name:  set_std_ref_num
0459 B444              *
0460 B444              * Description:  Sets refnum for prefix 10,11 or 12 (std i/o channels).
0461 B444              *
0462 B444              *      Author:  Greg Branche
0463 B444              *     Created:  September 1, 1991
0464 B444              *    Modified:
0465 B444              *
0466 B444              *       Entry:  jsr
0467 B444              *
0468 B444              *       Input:  A = undefined
0469 B444              *               X = undefined
0470 B444              *               Y = undefined
0471 B444              *               P = nvmxdizc
0472 B444              *                   ..000...
0473 B444              *
0474 B444              *               std_ref_num             ;table of 3 refnums (0=undefined).
0475 B444              *
0476 B444              *      Output:  A = Error code if error.
0477 B444              *               X = undefined
0478 B444              *               Y = undefined
0479 B444              *               P = nvmxdizc
0480 B444              *                   ..000..0 no error
0481 B444              *                          1 error
0482 B444              *
0483 B444              *        Exit:  rts
0484 B444              *
0485 B444              *        Uses:  set_ptr
0486 B444              *
0487 B444              * Copyright Apple Computer, Inc. 1988  All rights reserved.
0488 B444              *******************************************************************************
0489 B444
0490 B444              set_std_ref_num proc 
0491 B444                       Import std_prefix_num,last_ref_num
0492 B444              *
0493 B444              * Set up our access to the parameter block...
0494 B444              *
0495 B444 20 AC E3              jsr   set_ptr                  ;Set pb_ptr
0496 B447              *
0497 B447              * Make sure the prefix requested is 10, 11 or 12...
0498 B447              *
0499 B447 A2 53 00              ldx   #parm_range_err          ;Assume error.
0500 B44A
0501 B44A A0 00 00              ldy   #pblk_37_pfxnum          ;Get offset to prefix.
0502 B44D B7 FC                 lda   [<pb_ptr],y              ;Get the prefix number.
0503 B44F 38                    sec                            ;Put in range 0-2.
0504 B450 E9 0A 00              sbc   #10
0505 B453 C9 03 00              cmp   #3                       ;In range?
0506 B456 B0 22                 bcs   error                    ;Nope.
0507 B458              *
0508 B458              * It is. Save the index into the std_ref_num table
0509 B458              *
0510 B458 0A                    asl   a                        ;Use as word offset.
0511 B459 8D 21 B9              sta   std_prefix_num           ;Save for later.
0512 B45C              *
0513 B45C              * Make sure the requested ref_num is valid...
0514 B45C              *
0515 B45C A2 43 00              ldx   #invalid_ref_num         ;Assume error again.
0516 B45F A0 02 00              ldy   #pblk_37_refnum          ;Get offset to parm.
0517 B462 B7 FC                 lda   [<pb_ptr],y              ;Retrieve the refnum.
0518 B464 F0 14                 beq   error                    ;Ya can't have a zero refnum, meathead!
0519 B466 8D 23 B9              sta   last_ref_num             ;Save it.
0520 B469 22 72 F8 00           jsl   findfcr                  ;Make sure there's an FCR for the refnum.
0521 B46D B0 0D                 bcs   bad_refnum               ;No go, Joe!
0522 B46F              *
0523 B46F              * It is, so stuff it in the std_ref_num table and exit...
0524 B46F              *
0525 B46F AC 21 B9              ldy   std_prefix_num           ;Get the proper index value.
0526 B472 AD 23 B9              lda   last_ref_num             ;And the actual refnum.
0527 B475 99 1B B9              sta   std_ref_num,y
0528 B478
0529 B478 18                    clc                            ;Indicate no error.
0530 B479 60                    rts                            ;Exit.
0531 B47A
0532 B47A 38           error    sec                            ;Nope, so return error.
0533 B47B 8A                    txa   
0534 B47C              bad_refnum  
0535 B47C 60                    rts   
0536 B47D                       end_proc 
0537 B47D                       eject 
0538 B47D              *******************************************************************************
0539 B47D              *
0540 B47D              *        Name:  insert_vol_name
0541 B47D              *
0542 B47D              * Description:  If the input path contained a device name/number, this routine
0543 B47D              *               will attempt to build a new output string with the volume name
0544 B47D              *               replacing the device name/number.
0545 B47D              *
0546 B47D              *      Author:  Bryan Atsatt
0547 B47D              *     Created:  Feb 20, 1989
0548 B47D              *    Modified:  Jan 23, 1992
0549 B47D              *
0550 B47D              *       Entry:  jsl
0551 B47D              *
0552 B47D              *       Input:  A = undefined
0553 B47D              *               X = undefined
0554 B47D              *               Y = undefined
0555 B47D              *               P = nvmxdizc
0556 B47D              *                   ..000...
0557 B47D              *
0558 B47D              *               param_blk_ptr           ;Points to caller's parms.
0559 B47D              *               fst_flags               ;Set up by expand_path
0560 B47D              *               path1_ptr               ;Set up by expand_path
0561 B47D              *               v_ptr1                  ;Set up by expand_path
0562 B47D              *
0563 B47D              *      Output:  A = undefined
0564 B47D              *               X = undefined
0565 B47D              *               Y = undefined
0566 B47D              *               P = nvmxdizc
0567 B47D              *                   ..000..0
0568 B47D              *
0569 B47D              *               path1_ptr               ;Points to original or new outpath.
0570 B47D              *
0571 B47D              *        Exit:  rtl
0572 B47D              *
0573 B47D              *        Uses:  alloc_string
0574 B47D              *
0575 B47D              * Copyright Apple Computer, Inc. 1989  All rights reserved.
0576 B47D              *******************************************************************************
0577 B47D
0578 B47D              insert_vol_name proc 
0579 B47D
0580 B47D              class1_volume equ   $2008               ;Class 1 volume call #.
0581 B47D              volume_x2 equ   $0010                   ;Volume call # times 2.
0582 B47D              exp_path_num equ   $200e                ;Expand_path call number.
0583 B47D              period   equ   $002e                    ;Period.
0584 B47D
0585 B47D              *
0586 B47D              * Was there a device name or number in the path?  Exit if not...
0587 B47D              *
0588 B47D A0 02 00              ldy   #0002                    ;Get offset to first char.
0589 B480 B7 3A                 lda   [<path1_ptr],y           ;Get first character.
0590 B482 29 FF 00              and   #$00ff                   ;Isolate low byte.
0591 B485 C9 2E 00              cmp   #period                  ;Is period?
0592 B488 F0 01                 beq   do_it                    ;Yep.
0593 B48A 6B                    rtl                            ;Nope, so exit,
0594 B48B              *
0595 B48B              * Yes, so we need to do a volume call to try to get the name for the selected
0596 B48B              * device.  First save some parameters...
0597 B48B              *
0598 B48B AD C6 B9     do_it    lda   |v_ptr1                  ;Save v_ptr1.
0599 B48E 48                    pha   
0600 B48F AD C8 B9              lda   |v_ptr1+2
0601 B492 48                    pha   
0602 B493 D4 32                 pei   <param_blk_ptr           ;Save param_blk_ptr.
0603 B495 D4 34                 pei   <param_blk_ptr+2
0604 B497
0605 B497 D4 30                 pei   <call_number             ;save current call number
0606 B499
0607 B499 D4 3A                 pei   <path1_ptr               ;Save path1_ptr.
0608 B49B D4 3C                 pei   <path1_ptr+2
0609 B49D
0610 B49D AD 19 B9              lda   |fst_flags               ;Save flags word.
0611 B4A0 48                    pha   
0612 B4A1              *
0613 B4A1              * Copy just the device name/number into our input path...
0614 B4A1              *
0615 B4A1 E2 20                 sep   #m8                      ;Go to 8 bit A.
0616 B4A3                       longa off
0617 B4A3
0618 B4A3 A0 01 00              ldy   #0001                    ;Point to first char-1.
0619 B4A6 A2 FF FF              ldx   #$ffff                   ;Point to start-1.
0620 B4A9
0621 B4A9 C8           copy_name iny                           ;Bump offsets.
0622 B4AA E8                    inx   
0623 B4AB B7 3A                 lda   [<path1_ptr],y           ;Copy name to device_name.
0624 B4AD 9D 62 B9              sta   device_name+2,x          ;Save it.
0625 B4B0 F0 04                 beq   set_length               ;Done if zero.
0626 B4B2 C9 3A                 cmp   #sep                     ;Is separator?
0627 B4B4 D0 F3                 bne   copy_name                ;Nope, so loop.
0628 B4B6
0629 B4B6 9E 62 B9     set_length stz   device_name+2,x        ;Add terminator.
0630 B4B9
0631 B4B9 C2 20                 rep   #m8                      ;Back to 16 bit A.
0632 B4BB                       longa on
0633 B4BB
0634 B4BB 8E 60 B9              stx   device_name              ;Set length.
0635 B4BE 8E 90 B9              stx   dev_name_length          ;Save for later.
0636 B4C1              *
0637 B4C1              * Do call and exit to restore_exit if error...
0638 B4C1              *
0639 B4C1 20 4B B5              jsr   do_volume_call           ;Go do volume call.
0640 B4C4 7A                    ply                            ;Recover flags word.
0641 B4C5 8C 19 B9              sty   |fst_flags
0642 B4C8 7A                    ply                            ;Recover pointer.
0643 B4C9 84 3C                 sty   <path1_ptr+2
0644 B4CB 7A                    ply   
0645 B4CC 84 3A                 sty   <path1_ptr
0646 B4CE B0 68                 bcs   restore_exit             ;Exit if error. 
0647 B4D0              *
0648 B4D0              * Call succeeded.  Now path1_ptr points to original translated path and
0649 B4D0              * device_name holds volume name.  Now let's figure out the length of the
0650 B4D0              * new, concatenated string.  To do this, we have to get the length of the
0651 B4D0              * original path minus the device name/number and add the length of the
0652 B4D0              * volume name to it...
0653 B4D0              *
0654 B4D0 38                    sec                            ;Prepare to subtract.
0655 B4D1 A7 3A                 lda   [<path1_ptr]             ;Get original length.
0656 B4D3 ED 90 B9              sbc   dev_name_length          ;Subtract device name len.
0657 B4D6 18                    clc                            ;Now add volume name len.
0658 B4D7 6D 60 B9              adc   device_name
0659 B4DA 69 03 00              adc   #0003                    ;Add 3 for length word and 0.
0660 B4DD A8                    tay                            ;And put new length in Y.
0661 B4DE              *
0662 B4DE              * Ok, length is in Y, go allocate string.  Exit to restore_exit if error...
0663 B4DE              *
0664 B4DE A9 01 00              lda   #0001                    ;Set so allocate will use
0665 B4E1 8D AE B9              sta   |xlate_count             ; path2_ptr and v_ptr2.
0666 B4E4 20 30 E1              jsr   alloc_string             ;Get space for a new string.
0667 B4E7 B0 4F                 bcs   restore_exit             ;Error.
0668 B4E9              *
0669 B4E9              * Alright, we're all set to do the copy into the space pointed to by
0670 B4E9              * path2_ptr.  First copy the volume name in, forcing the case if required...
0671 B4E9              *
0672 B4E9 E2 20                 sep   #m8                      ;Go to 8 bit A.
0673 B4EB                       longa off
0674 B4EB
0675 B4EB A9 FF                 lda   #%11111111               ;Init mask to no change.
0676 B4ED AE 19 B9              ldx   |fst_flags               ;Force case?
0677 B4F0 10 02                 bpl   set_mask                 ;Nope, so leave mask alone.
0678 B4F2 A9 DF                 lda   #%11011111               ;Yes, set to clear bit. 
0679 B4F4 8D 92 B9     set_mask sta   |case_mask2
0680 B4F7
0681 B4F7 AE 60 B9              ldx   device_name              ;Get offset to end of string.
0682 B4FA 9E 62 B9              stz   device_name+2,x          ;Add null terminator.
0683 B4FD
0684 B4FD A0 01 00              ldy   #0001                    ;Init offset.
0685 B500 C8           volume_loop iny                         ;Bump offset.
0686 B501 B9 60 B9              lda   device_name,y            ;Get byte.
0687 B504 C9 61                 cmp   #'a'                     ;Is lower case?
0688 B506 90 07                 bcc   save_it                  ;Nope.
0689 B508 C9 7B                 cmp   #'z'+1                   ;Maybe.
0690 B50A B0 03                 bcs   save_it                  ;Nope.
0691 B50C 2D 92 B9              and   |case_mask2              ;Yes, so mask it.
0692 B50F 97 3E        save_it  sta   [<path2_ptr],y           ;Copy it.
0693 B511 C9 00                 cmp   #00                      ;Reached end?
0694 B513 D0 EB                 bne   volume_loop              ;Nope, so loop.
0695 B515              *
0696 B515              * Now, starting from the end of the device name/number in the original path,
0697 B515              * copy to the end of our new string...
0698 B515              *
0699 B515 BB                    tyx                            ;Save destination offset.
0700 B516 AC 90 B9              ldy   dev_name_length          ;Get offset to 1st char after
0701 B519                                                      ; the device name in original.
0702 B519 C8                    iny                            ;Bump past length word.
0703 B51A C8                    iny   
0704 B51B
0705 B51B B7 3A        append_loop lda   [<path1_ptr],y        ;Get byte.
0706 B51D 5A                    phy                            ;Save source offset.
0707 B51E 9B                    txy                            ;Recover destination offset.
0708 B51F 97 3E                 sta   [<path2_ptr],y           ;Copy byte.
0709 B521 7A                    ply                            ;Recover source offset.
0710 B522 C8                    iny                            ;Bump offsets.
0711 B523 E8                    inx   
0712 B524 C9 00                 cmp   #00                      ;Done with append?
0713 B526 D0 F3                 bne   append_loop              ;Nope, so loop.
0714 B528              *
0715 B528              * Now set the new length using the value in X minus 3 for the length word
0716 B528              * and the null terminator...
0717 B528              *
0718 B528 C2 20                 rep   #m8                      ;Back to 16 bit A.
0719 B52A                       longa on
0720 B52A
0721 B52A CA                    dex                            ;Subtract 3 from length.
0722 B52B CA                    dex   
0723 B52C CA                    dex   
0724 B52D 8A                    txa   
0725 B52E 87 3E                 sta   [<path2_ptr]             ;Save new length.
0726 B530
0727 B530              * Now set path1_ptr = path2_ptr so when we exit, expand_path will use the
0728 B530              * new path...
0729 B530              *
0730 B530 A5 3E                 lda   <path2_ptr               ;Copy pointer.
0731 B532 85 3A                 sta   <path1_ptr
0732 B534 A5 40                 lda   <path2_ptr+2
0733 B536 85 3C                 sta   <path1_ptr+2
0734 B538              *
0735 B538              * We're done, so restore environment and exit...
0736 B538              *
0737 B538 68           restore_exit pla                        ;Restore call number.
0738 B539 85 30                 sta   <call_number
0739 B53B
0740 B53B 68                    pla                            ;Restore param_blk_ptr.
0741 B53C 85 34                 sta   <param_blk_ptr+2
0742 B53E 68                    pla   
0743 B53F 85 32                 sta   <param_blk_ptr
0744 B541
0745 B541 68                    pla                            ;Restore v_ptr1.
0746 B542 8D C8 B9              sta   |v_ptr1+2
0747 B545 68                    pla   
0748 B546 8D C6 B9              sta   |v_ptr1
0749 B549
0750 B549 18                    clc                            ;Force no error.
0751 B54A 6B                    rtl                            ;Exit.
0752 B54B
0753 B54B                       end_proc 
0754 B54B                       eject 
0755 B54B              *******************************************************************************
0756 B54B              *
0757 B54B              *        Name:  do_volume_call
0758 B54B              *
0759 B54B              * Description:  Does an internal volume call.
0760 B54B              *
0761 B54B              *      Author:  Bryan Atsatt
0762 B54B              *     Created:  Mar 9, 1989
0763 B54B              *    Modified:
0764 B54B              *
0765 B54B              *       Entry:  jsr
0766 B54B              *
0767 B54B              *       Input:  A = undefined
0768 B54B              *               X = undefined
0769 B54B              *               Y = undefined
0770 B54B              *               P = nvmxdizc
0771 B54B              *                   ..000...
0772 B54B              *
0773 B54B              *               path1_ptr               ;Points to device name/number.
0774 B54B              *
0775 B54B              *      Output:  A = error code
0776 B54B              *               X = undefined
0777 B54B              *               Y = undefined
0778 B54B              *               P = nvmxdizc
0779 B54B              *                   ..000..0 no error
0780 B54B              *                          1 error
0781 B54B              *
0782 B54B              *        Exit:  rts
0783 B54B              *
0784 B54B              *        Uses:  do_type_2
0785 B54B              *               volume_name
0786 B54B              *               device_name
0787 B54B              *
0788 B54B              * Copyright Apple Computer, Inc. 1989  All rights reserved.
0789 B54B              *******************************************************************************
0790 B54B
0791 B54B              do_volume_call proc 
0792 B54B
0793 B54B              class1_volume equ   $2008               ;Class 1 volume call #.
0794 B54B              volume_x2 equ   $0010                   ;Volume call # times 2.
0795 B54B
0796 B54B              *
0797 B54B              * Set up the environment for the volume call...
0798 B54B              *
0799 B54B A9 F6 D3              lda   #path_script             ;Point script_start to special
0800 B54E 8D A6 B9              sta   script_start             ; script for pathname only.
0801 B551 A9 08 20              lda   #class1_volume           ;Set call number.
0802 B554 85 30                 sta   <call_number
0803 B556 A9 10 00              lda   #volume_x2               ;Set num to call # times 2.
0804 B559 8D A0 B9              sta   |num
0805 B55C A9 54 B9              lda   #volume_parms            ;Set param_blk_ptr to our parms.
0806 B55F 85 32                 sta   <param_blk_ptr
0807 B561 A9 00 00              lda   #volume_parms>>16
0808 B564 85 34                 sta   <param_blk_ptr+2
0809 B566 AD A2 B9              lda   |class                   ;Save class.
0810 B569 48                    pha   
0811 B56A A9 02 00              lda   #0002                    ;Set to class 1.
0812 B56D 8D A2 B9              sta   |class
0813 B570              *
0814 B570              * Do call, restore class and exit...
0815 B570              *
0816 B570 20 CA D7              jsr   do_type_2                ;Go do volume call.
0817 B573 FA                    plx                            ;Restore class.
0818 B574 8E A2 B9              stx   |class
0819 B577 60                    rts                            ;Exit.
0820 B578
0821 B578                       end_proc 
0822 B578                       eject 
0823 B578              *******************************************************************************
0824 B578              *
0825 B578              *        Name:  get_ref_num
0826 B578              *
0827 B578              * Description:  Returns a ref_num if selected pathname is open.
0828 B578              *
0829 B578              *      Author:  Bryan Atsatt
0830 B578              *     Created:  Feb 21, 1989
0831 B578              *    Modified:  Jun 2, 1989   BPA  Was returning access when pcount was 2!
0832 B578              *
0833 B578              *       Entry:  jsr
0834 B578              *
0835 B578              *       Input:  A = undefined
0836 B578              *               X = undefined
0837 B578              *               Y = undefined
0838 B578              *               P = nvmxdizc
0839 B578              *                   ..000...
0840 B578              *
0841 B578              *               param_blk_ptr           ;Points to caller's parms.
0842 B578              *
0843 B578              *      Output:  A = Error code
0844 B578              *               X = undefined
0845 B578              *               Y = undefined
0846 B578              *               P = nvmxdizc
0847 B578              *                   ..000..0 no error
0848 B578              *                          1 error code in A
0849 B578              *
0850 B578              *        Exit:  rts
0851 B578              *
0852 B578              *        Uses:  xlate_path
0853 B578              *               getfcr
0854 B578              *               find_fst
0855 B578              *               release_v_ptrs
0856 B578              *
0857 B578              * Copyright Apple Computer, Inc. 1989  All rights reserved.
0858 B578              *******************************************************************************
0859 B578
0860 B578              get_ref_num proc 
0861 B578                       Import e1_get_ref_num,std_prefix_num
0862 B578
0863 B578              msb_mask equ   s_temp1                  ;Temp equate.
0864 B578              character equ   s_temp2                 ;Temp equate.
0865 B578              fcr_ptr_temp equ   s_temp3              ;Temp equate.
0866 B578
0867 B578              ref_offset equ   $0006                  ;Offset to ref_num parm.
0868 B578              access_offset equ   $0008               ;Offset to access_parm
0869 B578              fork_offset equ   $000a                 ;Offset to form_num parm.
0870 B578              case_offset equ   $000c                 ;Offset to case_sense parm.
0871 B578              disp_offset equ   $000e                 ;Offset to displacement parm.
0872 B578
0873 B578              *
0874 B578              * First set up the default controls in case parameters are not present in the
0875 B578              * parameter list, and initalize pathname translation variables... 
0876 B578              *
0877 B578 9C 94 B9              stz   |fork_num                ;Select data fork.
0878 B57B 9C 96 B9              stz   |case_sense              ;Select insensitive.
0879 B57E A9 01 00              lda   #0001                    ;Select 1st match.
0880 B581 8D 98 B9              sta   |displacement
0881 B584 20 74 E2              jsr   init_path_vars           ;Init pathname variables.
0882 B587 9C 21 B9              stz   std_prefix_num           ;assume it's not a Std I/O prefix number
0883 B58A              *
0884 B58A              * We know pcount is in range 'cuz it was checked by check_call.  Now let's
0885 B58A              * check the remaining parameters, overwriting the defaults where required...
0886 B58A              *
0887 B58A A7 32                 lda   [<param_blk_ptr]         ;Get pcount.
0888 B58C AA                    tax   
0889 B58D
0890 B58D E0 04 00              cpx   #4                       ;Do we have a fork_num?
0891 B590 90 34                 bcc   set_case                 ;Nope.
0892 B592 A0 0A 00              ldy   #fork_offset             ;Yes, get offset.
0893 B595 B7 32                 lda   [<param_blk_ptr],y       ;Get parm.
0894 B597 C9 02 00              cmp   #0002                    ;In range 0-1?
0895 B59A B0 24                 bcs   parm_error               ;No, so error.
0896 B59C 8D 94 B9              sta   |fork_num                ;Yes, so save control.
0897 B59F
0898 B59F E0 05 00              cpx   #5                       ;Yes do we have a case parm?
0899 B5A2 90 22                 bcc   set_case                 ;Nope.
0900 B5A4 A0 0C 00              ldy   #case_offset             ;Yes, get offset.
0901 B5A7 B7 32                 lda   [<param_blk_ptr],y       ;Get parm.
0902 B5A9 C9 02 00              cmp   #0002                    ;In range 0-1?
0903 B5AC B0 12                 bcs   parm_error               ;No, so error.
0904 B5AE 8D 96 B9              sta   |case_sense              ;Yes, so save control.
0905 B5B1
0906 B5B1 E0 06 00              cpx   #6                       ;Yes do we have a disp parm?
0907 B5B4 90 10                 bcc   set_case                 ;Nope.
0908 B5B6 A0 0E 00              ldy   #disp_offset             ;Yes, get offset.
0909 B5B9 B7 32                 lda   [<param_blk_ptr],y       ;Get parm.
0910 B5BB 8D 98 B9              sta   |displacement            ;Yes, so save control.
0911 B5BE 80 06                 bra   set_case                 ;Continue.
0912 B5C0
0913 B5C0 A9 53 00     parm_error lda   #parm_range_err        ;Return parm_range_err.
0914 B5C3 38                    sec   
0915 B5C4 80 23                 bra   release_exit             ;Exit.
0916 B5C6              *
0917 B5C6              * Now let's set up fst_flags to force upper case if case_insensitive selected
0918 B5C6              * and set case_mask2 accordingly...
0919 B5C6              *
0920 B5C6 A9 00 80     set_case lda   #$8000                   ;Assume force upper case.
0921 B5C9 A2 DF FF              ldx   #%1111111111011111
0922 B5CC AC 96 B9              ldy   |case_sense              ;Case insensitive requested?
0923 B5CF F0 06                 beq   set_flags                ;Yep.
0924 B5D1 A9 00 00              lda   #0000                    ;No, so don't force case.
0925 B5D4 A2 FF FF              ldx   #%1111111111111111
0926 B5D7 8D 19 B9     set_flags sta   |fst_flags              ;Save flags.
0927 B5DA 8E 92 B9              stx   |case_mask2              ;Save OR mask.
0928 B5DD              *
0929 B5DD              * Now try translation. This will set path1_ptr to the translated name.  Exit
0930 B5DD              * if error...
0931 B5DD              *
0932 B5DD A9 02 00              lda   #0002                    ;Get offset in parm list.
0933 B5E0 20 21 DD              jsr   xlate_path               ;Do translation.
0934 B5E3 B0 04                 bcs   release_exit             ;Exit on error.
0935 B5E5
0936 B5E5              ; call part 2, located in another bank
0937 B5E5
0938 B5E5 22 80 D9 E1           jsl   e1_get_ref_num
0939 B5E9
0940 B5E9 48           release_exit pha                        ;Save error.
0941 B5EA 08                    php                            ;Save status.
0942 B5EB 20 61 B7              jsr   release_v_ptrs           ;Release vps.
0943 B5EE 28                    plp                            ;Recover status.
0944 B5EF 68                    pla                            ;Recover error code.
0945 B5F0 60                    rts                            ;Exit.
0946 B5F1
0947 B5F1                       end_proc 
0948 B5F1                       eject 
0949 B5F1              *******************************************************************************
0950 B5F1              *
0951 B5F1              *        Name:  get_ref_info
0952 B5F1              *
0953 B5F1              * Description:  Returns access and pathname of open file with selected ref_num.
0954 B5F1              *
0955 B5F1              *      Author:  Bryan Atsatt
0956 B5F1              *     Created:  Feb 23, 1989
0957 B5F1              *    Modified:
0958 B5F1              *
0959 B5F1              *       Entry:  jsr
0960 B5F1              *
0961 B5F1              *       Input:  A = undefined
0962 B5F1              *               X = undefined
0963 B5F1              *               Y = undefined
0964 B5F1              *               P = nvmxdizc
0965 B5F1              *                   ..000...
0966 B5F1              *
0967 B5F1              *               param_blk_ptr           ;Points to caller's parms.
0968 B5F1              *
0969 B5F1              *      Output:  A = Error code
0970 B5F1              *               X = undefined
0971 B5F1              *               Y = undefined
0972 B5F1              *               P = nvmxdizc
0973 B5F1              *                   ..000..0 no error
0974 B5F1              *                          1 error code in A
0975 B5F1              *
0976 B5F1              *        Exit:  rts
0977 B5F1              *
0978 B5F1              *        Uses:  findfcr
0979 B5F1              *               chk_app_buf
0980 B5F1              *               copy_ext_string
0981 B5F1              *
0982 B5F1              * Copyright Apple Computer, Inc. 1989  All rights reserved.
0983 B5F1              *******************************************************************************
0984 B5F1
0985 B5F1              get_ref_info proc 
0986 B5F1                       Import e1_get_ref_info
0987 B5F1
0988 B5F1              ref_offset equ   $0002                  ;Offset to ref_num parm.
0989 B5F1              access_offset equ   $0004               ;Offset to access parm
0990 B5F1              outpath_offset equ   $0006              ;Offset to output path parm.
0991 B5F1              rsrcNum_offset equ   $000a
0992 B5F1              level_offset equ   $000c
0993 B5F1
0994 B5F1
0995 B5F1              *
0996 B5F1              * Since we got here we know that pcount is between 2 and 5, inclusive.  First let's see if
0997 B5F1              * we have an FCR with the ref_num given to us.  Exit with error if not...
0998 B5F1              *
0999 B5F1 A0 02 00              ldy   #ref_offset              ;Get offset to ref_num.
1000 B5F4 B7 32                 lda   [<param_blk_ptr],y       ;Get ref_num.
1001 B5F6 22 72 F8 00           jsl   findfcr                  ;Do we have one?
1002 B5FA B0 64                 bcs   exit                     ;Nope.
1003 B5FC 22 09 FE 00           jsl   deref2                   ;Yes, dereference vp.
1004 B600 86 D4                 stx   <s_temp1                 ;Save pointer.
1005 B602 84 D6                 sty   <s_temp1+2
1006 B604              *
1007 B604              * Ok, we found one, now get access bits and put them in the parameter list...
1008 B604              *
1009 B604 A0 14 00              ldy   #fcr_access              ;Get offset to access.
1010 B607 B7 D4                 lda   [<s_temp1],y             ;Get access.
1011 B609 29 03 00              and   #%0000000000000011       ;Isolate access bits.
1012 B60C A0 04 00              ldy   #access_offset           ;Get offset into parms.
1013 B60F 97 32                 sta   [<param_blk_ptr],y       ;Stuff it in.
1014 B611              *
1015 B611              * Did the caller want the pathname?  Exit with carry clear if not...
1016 B611              *
1017 B611 A7 32                 lda   [<param_blk_ptr]         ;Get pcount.
1018 B613 C9 03 00              cmp   #0003                    ;Want pathname?
1019 B616 90 48                 bcc   exit                     ;Nope, so exit.
1020 B618
1021 B618              *
1022 B618              * Yes, so get pointer to pathname from FCR, and check to make sure that the
1023 B618              * output buffer is large enough.  Exit with error if not...
1024 B618              *
1025 B618 A0 02 00              ldy   #fcr_path_name           ;Get offset to name.
1026 B61B B7 D4                 lda   [<s_temp1],y             ;Get low word.
1027 B61D AA                    tax                            ;Save it.
1028 B61E C8                    iny   
1029 B61F C8                    iny   
1030 B620 B7 D4                 lda   [<s_temp1],y             ;Get high word.
1031 B622 A8                    tay                            ;Put in Y.
1032 B623 22 09 FE 00           jsl   deref2                   ;Dereference it.
1033 B627 86 EC                 stx   <m_temp                  ;Save pointer.
1034 B629 84 EE                 sty   <m_temp+2
1035 B62B
1036 B62B A0 06 00              ldy   #outpath_offset          ;Get offset to outpath parm.
1037 B62E A7 EC                 lda   [<m_temp]                ;Get length of pathname.
1038 B630 20 A9 E5              jsr   chk_app_buf              ;App buffer big enough?
1039 B633 F0 05                 beq   null_ptr                 ;if NULL pointer, skip it!
1040 B635 B0 29                 bcs   exit                     ;Nope, so exit with error.
1041 B637
1042 B637              *
1043 B637              * It's big enough, so do the copy
1044 B637              *
1045 B637 20 01 B7              jsr   copy_ext_string          ;Copy the string.
1046 B63A              *
1047 B63A              * Now check for a request of the new parameters
1048 B63A              *
1049 B63A              null_ptr  
1050 B63A A7 32                 lda   [<param_blk_ptr]         ;Get pcount.
1051 B63C C9 04 00              cmp   #$0004                   ;either of the new parameters wanted?
1052 B63F 90 1F                 bcc   exit                     ;no, just exit
1053 B641 08                    php                            ;save Z flag (pCount status)
1054 B642 A0 14 00              ldy   #fcr_access              ;get the access word
1055 B645 B7 D4                 lda   [<s_temp1],y             ;bit 14 is 0 if data fork is open,
1056 B647 29 00 40              and   #$4000                   ;clear all but that bit
1057 B64A 0A                    asl   a                        ;shift into position
1058 B64B 0A                    asl   a
1059 B64C 2A                    rol   a                        ;and rotate into bottom bit
1060 B64D A0 0A 00              ldy   #rsrcNum_offset
1061 B650 97 32                 sta   [<param_blk_ptr],y
1062 B652
1063 B652 28                    plp                            ;retrieve Z flag
1064 B653 F0 0A                 beq   done                     ;if set, pCount == 4
1065 B655 A0 0A 00              ldy   #fcr_level               ;get the file system level used
1066 B658 B7 D4                 lda   [<s_temp1],y             ;  when the file was opened
1067 B65A A0 0C 00              ldy   #level_offset
1068 B65D 97 32                 sta   [<param_blk_ptr],y
1069 B65F              done      
1070 B65F 18                    clc                            ;no errors
1071 B660 60           exit     rts                            ;Exit.
1072 B661
1073 B661                       end_proc 
1074 B661                       eject 
1075 B661              *******************************************************************************
1076 B661              *
1077 B661              *        Name:  install_int_vec
1078 B661              *
1079 B661              * Description:  Installs interrupt_patch into main interrupt vector.  Does
1080 B661              *               nothing if already installed.
1081 B661              *
1082 B661              *      Author:  Bryan Atsatt
1083 B661              *     Created:  Feb 22, 1989
1084 B661              *    Modified:
1085 B661              *
1086 B661              *       Entry:  jsr
1087 B661              *
1088 B661              *       Input:  A = undefined
1089 B661              *               X = undefined
1090 B661              *               Y = undefined
1091 B661              *               P = nvmxdizc
1092 B661              *                   ..000...
1093 B661              *
1094 B661              *      Output:  A = undefined
1095 B661              *               X = undefined
1096 B661              *               Y = undefined
1097 B661              *               P = nvmxdizc
1098 B661              *                   ..000..?
1099 B661              *
1100 B661              *        Exit:  rts
1101 B661              *
1102 B661              *        Uses:  intmgrv                 ;Main interrupt vector.
1103 B661              *
1104 B661              * Copyright Apple Computer, Inc. 1989  All rights reserved.
1105 B661              *******************************************************************************
1106 B661
1107 B661              install_int_vec proc 
1108 B661
1109 B661              *
1110 B661              * Are we already installed?
1111 B661              *
1112 B661 AD 9E B9              lda   |patch_state             ;Are we already installed?
1113 B664 D0 2E                 bne   exit                     ;Yes, so do nothing.
1114 B666              *
1115 B666              * No, so do install.  First disable interrupts, then patch our patch with
1116 B666              * the contents of the main interrupt vector...
1117 B666              *
1118 B666 08                    php                            ;Save status.
1119 B667 78                    sei                            ;Disable interrupts.
1120 B668 EE 9E B9              inc   |patch_state             ;Set state to installed.
1121 B66B
1122 B66B AF 10 00 E1           lda   >intmgrv                 ;Get current vector, low.
1123 B66F 8D CB 9F              sta   |int_patch_1             ;Patch first location.
1124 B672 8D E0 9F              sta   |int_patch_2             ;Patch second location.
1125 B675 8D E7 9F              sta   |int_patch_3             ;Patch third location.
1126 B678
1127 B678 AF 12 00 E1           lda   >intmgrv+2               ;Get current vector, high.
1128 B67C 8D CD 9F              sta   |int_patch_1+2           ;Patch first location.
1129 B67F 8D E2 9F              sta   |int_patch_2+2           ;Patch second location.
1130 B682 8D E9 9F              sta   |int_patch_3+2           ;Patch third location.
1131 B685              *
1132 B685              * Now put address of our interrupt_patch into the main interrupt vector, 
1133 B685              * restore interrupt status and exit...
1134 B685              *
1135 B685 A9 BF 9F              lda   #interrupt_patch         ;Get address, low.
1136 B688 8F 11 00 E1           sta   >intmgrv+1               ;Stuff it into vector.
1137 B68C A9 9F 00              lda   #interrupt_patch>>8      ;Get address, middle.
1138 B68F 8F 12 00 E1           sta   >intmgrv+2               ;Stuff it into vector.
1139 B693
1140 B693 28                    plp                            ;Restore status.
1141 B694 60           exit     rts                            ;Done.
1142 B695
1143 B695                       end_proc 
1144 B695                       eject 
1145 B695              *******************************************************************************
1146 B695              *
1147 B695              *        Name:  remove_int_vec
1148 B695              *
1149 B695              * Description:  Remove interrupt_patch from main interrupt vector.  Does
1150 B695              *               nothing if already removed.
1151 B695              *
1152 B695              *      Author:  Bryan Atsatt
1153 B695              *     Created:  Feb 22, 1989
1154 B695              *    Modified:
1155 B695              *
1156 B695              *       Entry:  jsr
1157 B695              *
1158 B695              *       Input:  A = undefined
1159 B695              *               X = undefined
1160 B695              *               Y = undefined
1161 B695              *               P = nvmxdizc
1162 B695              *                   ..000...
1163 B695              *
1164 B695              *      Output:  A = undefined
1165 B695              *               X = undefined
1166 B695              *               Y = undefined
1167 B695              *               P = nvmxdizc
1168 B695              *                   ..000..?
1169 B695              *
1170 B695              *        Exit:  rts
1171 B695              *
1172 B695              *        Uses:  intmgrv                 ;Main interrupt vector.
1173 B695              *
1174 B695              * Copyright Apple Computer, Inc. 1989  All rights reserved.
1175 B695              *******************************************************************************
1176 B695
1177 B695              remove_int_vec proc 
1178 B695
1179 B695              *
1180 B695              * Are we currently installed?
1181 B695              *
1182 B695 AD 9E B9              lda   |patch_state             ;Are we installed?
1183 B698 F0 14                 beq   exit                     ;No, so do nothing.
1184 B69A              *
1185 B69A              * Yes, so remove our patch.  First disable interrupts and set patch_state to
1186 B69A              * zero...
1187 B69A              *
1188 B69A 08                    php                            ;Save status.
1189 B69B 78                    sei                            ;Disable interrupts.
1190 B69C 9C 9E B9              stz   |patch_state             ;Set state to not installed.
1191 B69F              *
1192 B69F              * Now restore original vector, restore interrupt status and exit...
1193 B69F              *
1194 B69F AD CB 9F              lda   |int_patch_1             ;Get original vector and put
1195 B6A2 8F 10 00 E1           sta   >intmgrv                 ; back in main vector.
1196 B6A6 AD CD 9F              lda   |int_patch_1+2
1197 B6A9 8F 12 00 E1           sta   >intmgrv+2
1198 B6AD
1199 B6AD 28                    plp                            ;Restore interrupt status.
1200 B6AE 60           exit     rts                            ;Exit.
1201 B6AF
1202 B6AF                       end_proc 
1203 B6AF                       eject 
1204 B6AF              *******************************************************************************
1205 B6AF              *
1206 B6AF              *        Name:  init_parsepath
1207 B6AF              *
1208 B6AF              * Description:  Clears internal variables for parse_path call.
1209 B6AF              *
1210 B6AF              *      Author:  Bryan Atsatt
1211 B6AF              *     Created:  Nov 16, 1988
1212 B6AF              *    Modified:  Apr 17, 1989
1213 B6AF              *
1214 B6AF              *       Entry:  jsl $1fcd4
1215 B6AF              *
1216 B6AF              *       Input:  A = undefined
1217 B6AF              *               X = undefined
1218 B6AF              *               Y = undefined
1219 B6AF              *               P = nvmxdizc
1220 B6AF              *                   ..000..0 = initialize
1221 B6AF              *                          1 = release vps.
1222 B6AF              *
1223 B6AF              *      Output:  A = undefined
1224 B6AF              *               X = undefined
1225 B6AF              *               Y = undefined
1226 B6AF              *               P = nvmxdizc
1227 B6AF              *                   ..000..x
1228 B6AF              *
1229 B6AF              *        Exit:  rtl
1230 B6AF              *
1231 B6AF              *        Uses:  init_path_vars
1232 B6AF              *               release_v_ptrs
1233 B6AF              *
1234 B6AF              * Copyright Apple Computer, Inc. 1988  All rights reserved.
1235 B6AF              *******************************************************************************
1236 B6AF
1237 B6AF              init_parsepath proc 
1238 B6AF
1239 B6AF 8B                    phb                            ;Save data bank.
1240 B6B0 4B                    phk                            ;Set to our code bank.
1241 B6B1 AB                    plb   
1242 B6B2 90 05                 bcc   do_init                  ;We're doing an init.
1243 B6B4 20 61 B7              jsr   release_v_ptrs           ;Release vps.
1244 B6B7 80 03                 bra   exit                     ;Exit.
1245 B6B9
1246 B6B9 20 74 E2     do_init  jsr   init_path_vars           ;Do initialization.
1247 B6BC AB           exit     plb                            ;Restore data bank.
1248 B6BD 6B                    rtl                            ;Exit.
1249 B6BE
1250 B6BE                       end_proc 
1251 B6BE                       eject 
1252 B6BE              *******************************************************************************
1253 B6BE              *
1254 B6BE              *        Name:  parse_path
1255 B6BE              *
1256 B6BE              * Description:  Translate pathname into canonical format for FST_Specific calls.
1257 B6BE              *
1258 B6BE              *        NOTE:  Must call system service call Init_Parse_path once before
1259 B6BE              *               calling this routine.
1260 B6BE              *
1261 B6BE              *      Author:  Bryan Atsatt
1262 B6BE              *     Created:  Nov 16, 1988
1263 B6BE              *    Modified:  Apr 7, 1989
1264 B6BE              *
1265 B6BE              *       Entry:  jsl $1fcc0
1266 B6BE              *
1267 B6BE              *       Input:  A = offset to pathname pointer in parameter list.
1268 B6BE              *               X = fst attribute flags word from FST header.
1269 B6BE              *               Y = 0000 to select pathname1, 0001 to select pathname2.
1270 B6BE              *               P = nvmxdizc
1271 B6BE              *                   ..000...
1272 B6BE              *
1273 B6BE              *      Output:  A = error code if error.
1274 B6BE              *               X = undefined
1275 B6BE              *               Y = undefined
1276 B6BE              *               P = nvmxdizc
1277 B6BE              *                   ..000..1 = error
1278 B6BE              *                          0 = no error
1279 B6BE              *
1280 B6BE              *               path_flag       ;indicates which pathname active.
1281 B6BE              *               dev1_num        ;device number if present and path1 active.
1282 B6BE              *               dev2_num        ;device number if present and path2 active.
1283 B6BE              *               span1           ;maximum name length if path1 active.
1284 B6BE              *               span2           ;maximum name length if path2 active.
1285 B6BE              *               path1_ptr       ;pointer to pathname if path1 active.
1286 B6BE              *               path2_ptr       ;pointer to pathname if path2 active.
1287 B6BE              *
1288 B6BE              *        Exit:  rtl
1289 B6BE              *
1290 B6BE              *        Uses:  xlate_path
1291 B6BE              *
1292 B6BE              * Copyright Apple Computer, Inc. 1988  All rights reserved.
1293 B6BE              *******************************************************************************
1294 B6BE
1295 B6BE              parse_path proc 
1296 B6BE
1297 B6BE 8B                    phb                            ;Save data bank.
1298 B6BF 4B                    phk                            ;Set to our code bank.
1299 B6C0 AB                    plb   
1300 B6C1
1301 B6C1 8C AE B9              sty   |xlate_count             ;Select pathname.
1302 B6C4 AC 19 B9              ldy   |fst_flags               ;Save current flags.
1303 B6C7 5A                    phy   
1304 B6C8 8E 19 B9              stx   |fst_flags               ;Set flags word.
1305 B6CB 20 21 DD              jsr   xlate_path               ;Do the name munging.
1306 B6CE 7A                    ply                            ;Restore flags.
1307 B6CF 8C 19 B9              sty   |fst_flags
1308 B6D2
1309 B6D2 AB                    plb                            ;Restore data bank.
1310 B6D3 6B                    rtl                            ;Exit
1311 B6D4
1312 B6D4                       end_proc 
1313 B6D4
1314 B6D4                       eject 
1315 B6D4              *******************************************************************************
1316 B6D4              *
1317 B6D4              *        Name:  force_lock and force_unlock
1318 B6D4              *
1319 B6D4              * Description:  Locks or unlocks all of GS/OS managed memory.
1320 B6D4              *
1321 B6D4              *      Author:  Bryan Atsatt
1322 B6D4              *     Created:  Mar 27, 1989
1323 B6D4              *    Modified:  Mar 27, 1989
1324 B6D4              *
1325 B6D4              *       Entry:  jsl
1326 B6D4              *
1327 B6D4              *       Input:  A = undefined
1328 B6D4              *               X = undefined
1329 B6D4              *               Y = undefined
1330 B6D4              *               P = nvmxdizc
1331 B6D4              *                   ..000...
1332 B6D4              *
1333 B6D4              *      Output:  A = undefined
1334 B6D4              *               X = undefined
1335 B6D4              *               Y = undefined
1336 B6D4              *               P = nvmxdizc
1337 B6D4              *                   ..000..x
1338 B6D4              *
1339 B6D4              *        Exit:  rtl
1340 B6D4              *
1341 B6D4              *        Uses:  ul_mem2
1342 B6D4              *
1343 B6D4              * Copyright Apple Computer, Inc. 1988  All rights reserved.
1344 B6D4              *******************************************************************************
1345 B6D4
1346 B6D4              rtl      equ   $6b                      ;Opcode for RTL.
1347 B6D4              jml      equ   $5c                      ;Opcode for JML.
1348 B6D4
1349 B6D4              force_lock proc 
1350 B6D4                       entry force_unlock
1351 B6D4
1352 B6D4 A2 03 00              ldx   #%0000000000000011       ;Select lock.
1353 B6D7 A9 6B 00              lda   #rtl                     ;Get RTL opcode.
1354 B6DA 80 06                 bra   do_it                    ;Go do it.
1355 B6DC
1356 B6DC A2 00 00     force_unlock ldx   #%0000000000000000   ;Select unlock.
1357 B6DF A9 5C 00              lda   #jml                     ;Get JML opcode.
1358 B6E2              *
1359 B6E2              * Patch or restore system service entry points for lock and unlock memory and
1360 B6E2              * call ul_mem2 selecting either lock or unlock...
1361 B6E2              *
1362 B6E2                       longa off
1363 B6E2 E2 20        do_it    sep   #$20                     ;Go to 8 bit A.
1364 B6E4
1365 B6E4 8F 68 FC 01           sta   >lock_vector             ;Patch/restore vector.
1366 B6E8 8F 6C FC 01           sta   >unlock_vector           ;Patch/restore vector.
1367 B6EC
1368 B6EC                       longa on
1369 B6EC C2 20                 rep   #$20                     ;Back to 16 bit A.
1370 B6EE
1371 B6EE 8A                    txa                            ;Get lock/unlock flag.
1372 B6EF 4A                    lsr   a                        ;Set/clear carry.
1373 B6F0 4C 3B FE              jmp   ul_mem2                  ;Go do it.
1374 B6F3
1375 B6F3                       end_proc 
1376 B6F3                       eject 
1377 B6F3              ;===============================================================================
1378 B6F3              ; init_fst_tbl:  Initialize FST Table to the empty state.
1379 B6F3              ;
1380 B6F3              ; Created:      4/10/87
1381 B6F3              ; Modified:     4/11/87
1382 B6F3              ; Author:       JJ
1383 B6F3              ;
1384 B6F3              ; Enter:        jsr     init_fst_tbl
1385 B6F3              ;               assumes DBR set to bank 0 (bank containing FST table)
1386 B6F3              ;
1387 B6F3              ; Input:        P = nvmxdizc
1388 B6F3              ;                   ..000...
1389 B6F3              ;
1390 B6F3              ; Output:       P = nvmxdizc
1391 B6F3              ;                   ..000..|
1392 B6F3              ;                          0=no error, 1=could not initialize table
1393 B6F3              ;===============================================================================
1394 B6F3
1395 B6F3              init_fst_tbl Proc 
1396 B6F3 9C 0F B8              stz   fst_count                ;initialize number of FSTs to 0
1397 B6F6 A9 FF FF              lda   #$FFFF                   ;set flag to indicate ProDOS FST not yet
1398 B6F9 8D 11 B9              sta   |prodos_index            ;... loaded
1399 B6FC 8D 13 B9              sta   |char_index
1400 B6FF
1401 B6FF 18                    clc                            ;indicate no error
1402 B700 60                    rts   
1403 B701                       end_proc 
1404 B701
1405 B701                       eject 
1406 B701              *******************************************************************************
1407 B701              *
1408 B701              * A bunch of small routines were moved from the gim_seg to here (below)...
1409 B701              *
1410 B701              *******************************************************************************
1411 B701
1412 B701              copy_ext_string proc 
1413 B701                       entry copy_gstring
1414 B701                       entry more
1415 B701
1416 B701 A7 EC                 lda   [m_temp]
1417 B703 80 03                 bra   over
1418 B705
1419 B705              copy_gstring  
1420 B705
1421 B705              ;Copy a GS/OS string (2 byte length) from source [m_temp] to dest [ptr]
1422 B705
1423 B705 A7 EC                 lda   [m_temp]                 ;Got the length
1424 B707 1A                    inc   a                        ;Compensate for trailing zero
1425 B708              over      
1426 B708 1A                    inc   a                        ;Comp for length word
1427 B709 A8                    tay                            ;Length in Y
1428 B70A
1429 B70A              more      
1430 B70A 88                    dey   
1431 B70B              more2     
1432 B70B B7 EC                 lda   [m_temp],y               ;Byte from source
1433 B70D 97 E8                 sta   [ptr],y                  ; into destination
1434 B70F 98                    tya   
1435 B710 F0 05                 beq   noxtra                   ;We've copied the last word
1436 B712 88                    dey   
1437 B713 D0 F5                 bne   more                     ;Okay as long as we haven't hit zero
1438 B715 80 F4                 bra   more2                    ;Odd length copy... skip a dey
1439 B717
1440 B717              noxtra    
1441 B717 60                    rts   
1442 B718
1443 B718                       entry to_copy_string
1444 B718              to_copy_string  
1445 B718 20 01 B7              jsr   copy_ext_string
1446 B71B 6B                    rtl   
1447 B71C
1448 B71C                       end_proc 
1449 B71C
1450 B71C              ldxy_idhand proc 
1451 B71C                       entry obj_type
1452 B71C
1453 B71C 48                    pha   
1454 B71D
1455 B71D AF 3A B7 00           lda   >obj_type
1456 B721 2A                    rol   a                        ;Put type into carry (C<-1 means FCR)
1457 B722
1458 B722 AF 8A FF 00           lda   >fcr_id_hand
1459 B726 B0 04                 bcs   skipa
1460 B728 AF 86 FF 00           lda   >vcr_id_hand
1461 B72C              skipa     
1462 B72C AA                    tax   
1463 B72D
1464 B72D AF 8C FF 00           lda   >fcr_id_hand+2
1465 B731 B0 04                 bcs   skipb
1466 B733 AF 88 FF 00           lda   >vcr_id_hand+2
1467 B737              skipb     
1468 B737 A8                    tay   
1469 B738
1470 B738 68                    pla                            ;Pull back A
1471 B739 60                    rts   
1472 B73A
1473 B73A 00 00        obj_type DS B:2                         ;Msb is flag indicating FCR/VCR
1474 B73C
1475 B73C                       end_proc 
1476 B73C
1477 B73C              deref2_vp proc 
1478 B73C
1479 B73C 48                    pha   
1480 B73D 86 F4                 stx   vp                       ;Keep for later
1481 B73F 84 F6                 sty   vp+2
1482 B741 22 09 FE 00           jsl   deref2
1483 B745 86 F8                 stx   vcr
1484 B747 84 FA                 sty   vcr+2
1485 B749 68                    pla   
1486 B74A 60                    rts   
1487 B74B
1488 B74B                       end_proc 
1489 B74B
1490 B74B              set_type proc 
1491 B74B
1492 B74B 48                    pha   
1493 B74C 6A                    ror   a
1494 B74D 8F 3A B7 00           sta   >obj_type
1495 B751 68                    pla   
1496 B752 60                    rts   
1497 B753
1498 B753                       end_proc 
1499 B753
1500 B753              list_index proc 
1501 B753
1502 B753 AF 3A B7 00           lda   >obj_type
1503 B757 2A                    rol   a
1504 B758 A9 00 00              lda   #vcr_list
1505 B75B 90 03                 bcc   skip
1506 B75D A9 04 00              lda   #fcr_list
1507 B760              skip      
1508 B760 60                    rts   
1509 B761
1510 B761                       end_proc 
1511 B761
1512 B761                       eject 
1513 B761              ;===============================================================================
1514 B761              ; release_v_ptrs
1515 B761              ;
1516 B761              ; Release space occupied by strings pointed to by virtual pointers
1517 B761              ; v_ptr and v_ptr2.
1518 B761              ;
1519 B761              ; Created:      6/12/87
1520 B761              ; Modified:
1521 B761              ; Author:       JJ
1522 B761              ;
1523 B761              ; Enter:        jsr     release_v_ptrs
1524 B761              ;
1525 B761              ; Input:        v_ptr1  first virtual pointer
1526 B761              ;               v_ptr2  second virtual pointer
1527 B761              ;               P = nvmxdizc
1528 B761              ;                   ..000...
1529 B761              ;
1530 B761              ; Output:       v_ptr1 and v_ptr2 are set to zero
1531 B761              ;               A = trashed
1532 B761              ;               X = trashed
1533 B761              ;               Y = trashed
1534 B761              ;               P = nvmxdizc
1535 B761              ;                   ..000...
1536 B761              ;===============================================================================
1537 B761
1538 B761              release_v_ptrs proc 
1539 B761
1540 B761 AC C8 B9              ldy   |v_ptr1+2
1541 B764 AE C6 B9              ldx   |v_ptr1                  ;release first virtual pointer if it is
1542 B767 D0 03                 bne   do_it2                   ;...non-zero.  Do nothing if it is zero.
1543 B769 98                    tya                            ;check the high word
1544 B76A F0 0A                 beq   do_2
1545 B76C
1546 B76C 22 15 FD 00  do_it2   jsl   >deallocate              ;release storage
1547 B770 9C C6 B9              stz   |v_ptr1                  ;zero out virtual pointer
1548 B773 9C C8 B9              stz   |v_ptr1+2
1549 B776
1550 B776              do_2      
1551 B776 AC CC B9              ldy   |v_ptr2+2
1552 B779 AE CA B9              ldx   |v_ptr2                  ;release second virtual pointer if it is
1553 B77C D0 03                 bne   do_it4                   ;...non-zero.  Do nothing if it is zero.
1554 B77E 98                    tya   
1555 B77F F0 0A                 beq   do_3
1556 B781
1557 B781 22 15 FD 00  do_it4   jsl   >deallocate              ;release storage
1558 B785 9C CA B9              stz   |v_ptr2                  ;zero out virtual pointer
1559 B788 9C CC B9              stz   |v_ptr2+2
1560 B78B
1561 B78B 60           do_3     rts   
1562 B78C
1563 B78C                       end_proc 
1564 B78C                       eject 
1565 B78C              ;==============================================================================
1566 B78C              ; is_bouncer
1567 B78C              ;
1568 B78C              ; Determine whether or not the error code in A is a bouncing error.
1569 B78C              ;
1570 B78C              ; Created:      1/28/88
1571 B78C              ; Modified:
1572 B78C              ; Author:       JJ
1573 B78C              ;
1574 B78C              ; Input:        A = error code to test
1575 B78C              ;               P = nvmxdizc
1576 B78C              ;                   ..000...
1577 B78C              ;
1578 B78C              ; Output:       A = error code to test
1579 B78C              ;               P = nvmxdizc
1580 B78C              ;                   ..000.|.
1581 B78C              ;                         z = 0, error is not a bouncing error
1582 B78C              ;                         z = 1, error is a bouncing error
1583 B78C              ;===============================================================================
1584 B78C
1585 B78C              is_bouncer proc 
1586 B78C
1587 B78C E2 20                 sep   #$20                     ;only compare low byte
1588 B78E                       longa off
1589 B78E C9 45                 cmp   #vol_not_found
1590 B790 F0 16                 beq   is_bounce
1591 B792 C9 52                 cmp   #unknown_vol
1592 B794 F0 12                 beq   is_bounce
1593 B796 C9 40                 cmp   #bad_path_syntax
1594 B798 F0 0E                 beq   is_bounce
1595 B79A C9 01                 cmp   #bad_system_call
1596 B79C F0 0A                 beq   is_bounce
1597 B79E C9 04                 cmp   #invalid_pcount
1598 B7A0 F0 06                 beq   is_bounce
1599 B7A2 C9 58                 cmp   #not_block_dev
1600 B7A4 F0 02                 beq   is_bounce
1601 B7A6 C9 88                 cmp   #network_error
1602 B7A8              *	beq	is_bounce
1603 B7A8
1604 B7A8              not_bounce  
1605 B7A8
1606 B7A8              is_bounce  
1607 B7A8 C2 20                 rep   #$20                     ;back to 16-bit accumulator
1608 B7AA                       longa on
1609 B7AA 60                    rts   
1610 B7AB
1611 B7AB                       end_proc 
1612 B7AB
1613 B7AB                       eject 
1614 B7AB              ;===============================================================================
1615 B7AB              ; call_fst:     Perform all of the processing needed to call an individual FST
1616 B7AB              ;               designated by the offset of the base of its entry in the
1617 B7AB              ;               FST Table (0, 16, 32,...).  This routine sets up the proper
1618 B7AB              ;               environment for the
1619 B7AB              ;               FST and saves and restores its own environment around the FST
1620 B7AB              ;               call.  It assumes the FST call parameters on direct page are
1621 B7AB              ;               already set up.
1622 B7AB              ;
1623 B7AB              ; Created:      5/11/87
1624 B7AB              ; Modified:     6/5/87
1625 B7AB              ;               7/31/87  Changed definition of A register input.
1626 B7AB              ; Author:       JJ
1627 B7AB              ;
1628 B7AB              ; Enter:        jsr     call_fst
1629 B7AB              ;
1630 B7AB              ; Input:        A = offset of the FST's entry in the FST table
1631 B7AB              ;               P = nvmxdizc
1632 B7AB              ;                   ..000...
1633 B7AB              ;
1634 B7AB              ; Output:       A = if c=0, undefined; if c=1, error code
1635 B7AB              ;                   relays the error code returned by the FST
1636 B7AB              ;
1637 B7AB              ;               X = trashed
1638 B7AB              ;               Y = trashed
1639 B7AB              ;               P = nvmxdizc
1640 B7AB              ;                   ..000..|
1641 B7AB              ;                          0=no error, 1=error
1642 B7AB              ;
1643 B7AB              ; Side effects: The called FST performs the call if it can.
1644 B7AB              ;===============================================================================
1645 B7AB              call_fst proc 
1646 B7AB                       entry return_from_fst
1647 B7AB                       import save_s
1648 B7AB              ;
1649 B7AB              ; Set up pathname translation jump vector to the FST's application entry point.
1650 B7AB              ;
1651 B7AB AA                    tax   
1652 B7AC
1653 B7AC BD 15 B8              lda   |fst_tbl+app_entry,x     ;get application entry point
1654 B7AF 8D C4 B7              sta   |jump_vector+1           ;... and set up jump vector for
1655 B7B2 BD 16 B8              lda   |fst_tbl+app_entry+1,x   ;... later jump to FST
1656 B7B5 8D C5 B7              sta   |jump_vector+2
1657 B7B8              ;
1658 B7B8              ; Prepare to call the FST
1659 B7B8              ;
1660 B7B8              if do_force_lock=0 then  
1661 B7B8                       jsl   force_lock               ;lock all of GS/OS memory for the FST
1662 B7B8              endif     
1663 B7B8 0B                    phd                            ;save D
1664 B7B9 3B                    tsc                            ;save S
1665 B7BA 8D AC B9              sta   |save_s
1666 B7BD AE A0 B9              ldx   |num                     ;X = 2*call_number
1667 B7C0 AC A2 B9              ldy   |class                   ;Y = 2*subclass
1668 B7C3              ;
1669 B7C3              ; pass control to the FST
1670 B7C3              ;
1671 B7C3 5C 35 1E 02  jump_vector jmp   >$000000              ;code above modifies this jump address
1672 B7C7
1673 B7C7              return_from_fst                         ;FST returns here by way of vector in
1674 B7C7                                                      ;... system service entry point table
1675 B7C7              ;
1676 B7C7              ; Restore DBR to proper value
1677 B7C7              ;
1678 B7C7 4B                    phk   
1679 B7C8 AB                    plb   
1680 B7C9              ;
1681 B7C9              ; Handle the error returned by the FST
1682 B7C9              ;
1683 B7C9 C2 30                 rep   #mx16                    ;force full native mode
1684 B7CB B0 03                 bcs   ar1                      ;branch if FST returned an error
1685 B7CD A9 00 00              lda   #$0000                   ;if no error, force A to 0
1686 B7D0              ar1       
1687 B7D0              *	and	#$00FF	;force high byte of error number to 0
1688 B7D0              ;
1689 B7D0              ; Restore registers
1690 B7D0              ;
1691 B7D0 AE AC B9              ldx   |save_s                  ;restore S
1692 B7D3 9A                    txs   
1693 B7D4 2B                    pld                            ;restore D
1694 B7D5              if do_force_lock=0 then  
1695 B7D5                       pha                            ;save error code
1696 B7D5                       jsl   force_unlock             ;unlock our memory again
1697 B7D5                       pla                            ;restore error code
1698 B7D5              endif     
1699 B7D5              ;
1700 B7D5              ; Set c bit according to error number, which is still in A
1701 B7D5              ;
1702 B7D5 C9 01 00              cmp   #$0001                   ;set c bit according to error number
1703 B7D8
1704 B7D8 60                    rts   
1705 B7D9
1706 B7D9                       end_proc 
1707 B7D9
1708 B7D9                       eject 
1709 B7D9              ;===============================================================================
1710 B7D9              ; do_type_0
1711 B7D9              ;
1712 B7D9              ; Handle calls with call type of zero.  This is a system error condition.
1713 B7D9              ;===============================================================================
1714 B7D9
1715 B7D9              do_type_0 proc 
1716 B7D9
1717 B7D9 22 02 EF 00           jsl   >s_sys_death
1718 B7DD
1719 B7DD                       end_proc 
1720 B7DD                       eject 
1721 B7DD              ;===============================================================================
1722 B7DD              ; do_type_1
1723 B7DD              ;
1724 B7DD              ; Handle read_block and write_block calls.  These are unconditionally passed
1725 B7DD              ; to the ProDOS FST, if it exists.
1726 B7DD              ;===============================================================================
1727 B7DD
1728 B7DD              do_type_1 proc 
1729 B7DD
1730 B7DD AD 11 B9              lda   |prodos_index            ;get index number of ProDOS FST
1731 B7E0 C9 FF FF              cmp   #$FFFF                   ;does ProDOS FST exist
1732 B7E3 F0 03                 beq   no_prodos
1733 B7E5
1734 B7E5 4C AB B7              jmp   call_fst                 ;call the ProDOS FST, return from there
1735 B7E8
1736 B7E8 A9 5D 00     no_prodos lda   #os_unsupported         ;indicate that ProDOS FST is unavailable
1737 B7EB 38                    sec   
1738 B7EC 60                    rts   
1739 B7ED
1740 B7ED                       end_proc 
1741 B7ED                       eject 
1742 B7ED              ;==============================================================================
1743 B7ED              ; cmp_11_12
1744 B7ED              ;
1745 B7ED              ; Compares contents of prefixes 11 and 12.
1746 B7ED              ;
1747 B7ED              ; Created:      9/1/91
1748 B7ED              ; Modified:
1749 B7ED              ; Author:       GAB
1750 B7ED              ;
1751 B7ED              ; Output:       P = nvmxdizc
1752 B7ED              ;                   ..000.|.
1753 B7ED              ;                         z = 0, prefixes are not equal
1754 B7ED              ;                         z = 1, prefixes are equal
1755 B7ED              ;===============================================================================
1756 B7ED
1757 B7ED              cmp_11_12 Proc                          ;compare prefix 11 to prefix 12
1758 B7ED                       Import string_compare,case_mask
1759 B7ED
1760 B7ED A9 0B 00              lda   #11                      ;get the pointer to prefix 11
1761 B7F0 20 DD E3              jsr   get_pfx
1762 B7F3 D4 EE                 pei   m_temp+2                 ;save pointer
1763 B7F5 D4 EC                 pei   m_temp
1764 B7F7 A9 0C 00              lda   #12                      ;now get the pointer to prefix 12
1765 B7FA 20 DD E3              jsr   get_pfx
1766 B7FD 68                    pla                            ;restore prefix 11 pointer
1767 B7FE 85 E8                 sta   ptr
1768 B800 68                    pla   
1769 B801 85 EA                 sta   ptr+2
1770 B803 A9 20 00              lda   #$0020                   ;set flag for case-insensitive compare
1771 B806 8D BF F8              sta   case_mask
1772 B809 20 C1 F8              jsr   string_compare           ;compare dem strings
1773 B80C 60                    rts                            ;return with proper Z flag
1774 B80D
1775 B80D                       end_proc 
1776 B80D
1777 B80D                       eject 
1778 B80D              *******************************************************************************
1779 B80D              * FST Table Data Structures
1780 B80D              *
1781 B80D              * NOTE:  The equates in this record are commented out and are here for 
1782 B80D              *        documentation purposes only.  The actual definitions are at the start
1783 B80D              *        of this file.
1784 B80D              *
1785 B80D              * WARNING:  This data MUST reside in non-language-card memory so that the
1786 B80D              *           Init Mgr can access it to build it's FST list.
1787 B80D              *
1788 B80D              *******************************************************************************
1789 B80D
1790 B80D              fst_tbl_data proc 
1791 B80D
1792 B80D                       entry fst_entry_size
1793 B80D                       entry fst_count
1794 B80D                       entry fst_tbl
1795 B80D                       entry prodos_index
1796 B80D                       entry char_index
1797 B80D                       entry curr_fst
1798 B80D                       entry last_fst
1799 B80D                       entry fst_flags
1800 B80D
1801 B80D              ;max_fsts	equ	16	;maximum number of FSTs allowed
1802 B80D
1803 B80D              ; offsets of fields within an FST Table entry
1804 B80D
1805 B80D              ;fst_hdr_ptr	equ	0	;pointer to FST header
1806 B80D              ;app_entry	equ	fst_hdr_ptr+4	;address of FST's application entry pt
1807 B80D              ;sys_entry	equ	app_entry+4	;address of FST's system entry point
1808 B80D              ;id		equ	sys_entry+4	;FST id value
1809 B80D              ;s_flags	equ	id+2	;flags
1810 B80D                                                      ;bit 15=0, do not upper case pathnames
1811 B80D                                                      ;      =1, force upper case in pathnames
1812 B80D                                                      ;bit 14=0, the FST is a block FST
1813 B80D                                                      ;      =1, the FST is a character FST
1814 B80D
1815 B80D              ;entry_size	equ	s_flags+2
1816 B80D              ;table_size	equ	max_fsts*entry_size
1817 B80D
1818 B80D 10 00        fst_entry_size DC W:entry_size          ;word containing size of each entry
1819 B80F 02 00        fst_count DS B:2                        ;current number of FSTs in table
1820 B811 C3 1D 02 00  fst_tbl  DS B:table_size                ;the FST Table
1821 B911
1822 B911 00 00        prodos_index DC W:0000                  ;index of entry for ProDOS FST
1823 B913 10 00        char_index DC W:0000                    ; index of entry for Char FST
1824 B915                                                      ; =$FFFF if there is no ProDOS or Char FST
1825 B915
1826 B915              ;init_fst	equ	$0002	;code to init FST call
1827 B915              ;kill_fst	equ	$0004	;code to shtdwn of FST
1828 B915              ;kill_vcr	equ	$0006	;code to free FST specific data from VCR
1829 B915              ;flush_def	equ	$0008	;code to flush deferred blks on a VCR
1830 B915
1831 B915 00 00        curr_fst DC W:0000                      ;offset of table entry for FST
1832 B917                                                      ;...to be called next
1833 B917 20 00        last_fst DC W:0000                      ;offset of byte just past end
1834 B919                                                      ;...of FST table
1835 B919 03 30        fst_flags DC W:0000                     ;FST's pathname translation attributes
1836 B91B
1837 B91B                       end_proc 
1838 B91B                       eject 
1839 B91B              *******************************************************************************
1840 B91B              *
1841 B91B              * Miscellaneous Data 
1842 B91B              *
1843 B91B              * NOTE:  The equates in this record are commented out and are here for 
1844 B91B              *        documentation purposes only.  The actual definitions are at the start
1845 B91B              *        of this file.
1846 B91B              *
1847 B91B              *******************************************************************************
1848 B91B
1849 B91B              misc_data proc 
1850 B91B
1851 B91B                       entry hs_fst_flag
1852 B91B                       entry iso_fst_header
1853 B91B                       entry iso_fst_id
1854 B91B                       entry std_ref_num
1855 B91B                       entry std_prefix_num
1856 B91B                       entry last_ref_num
1857 B91B                       entry volume_parms
1858 B91B                       entry volume_name
1859 B91B                       entry device_name
1860 B91B                       entry dev_name_length
1861 B91B                       entry case_mask2
1862 B91B                       entry fork_num
1863 B91B                       entry case_sense
1864 B91B                       entry displacement
1865 B91B                       entry fcr_index
1866 B91B                       entry found_count
1867 B91B                       entry patch_state
1868 B91B                       entry num
1869 B91B                       entry class
1870 B91B                       entry type
1871 B91B                       entry script_start
1872 B91B                       entry script_current
1873 B91B                       entry save_s
1874 B91B                       entry xlate_count
1875 B91B                       entry xlate_type
1876 B91B                       entry cont_offset
1877 B91B                       entry str_len
1878 B91B                       entry prefix_number
1879 B91B                       entry default_prefix
1880 B91B                       entry fstError
1881 B91B                       entry first_fst
1882 B91B                       entry volname_vp
1883 B91B                       entry volname_ptr
1884 B91B                       entry v_ptr1
1885 B91B                       entry v_ptr2
1886 B91B                       entry partial_len
1887 B91B                       entry save_control
1888 B91B                       entry char_mask
1889 B91B                       entry handler_addr
1890 B91B                       entry s_level
1891 B91B              *
1892 B91B              * The following table holds the ref_nums for standard prefixes 10,11 & 12. A
1893 B91B              * value of zero means that the ref_num is undefined.  The two words following
1894 B91B              * the table are used to know when and how to update the table.
1895 B91B              *
1896 B91B                       entry stdin_refnum,stdout_refnum,stderr_refnum
1897 B91B              std_ref_num  
1898 B91B 00 00        stdin_refnum DC W:0000                  ;Ref_num for prefix 10.
1899 B91D 00 00        stdout_refnum DC W:0000                 ;Ref_num for prefix 11.
1900 B91F 00 00        stderr_refnum DC W:0000                 ;Ref_num for prefix 12.
1901 B921
1902 B921 00 00        std_prefix_num DC W:0000                ;Standard prefix number.
1903 B923 00 00        last_ref_num DC W:0000                  ;Last reference #.
1904 B925              *
1905 B925              * The following data is used to simulate an ISO 9660 FST.  The hs_fst_flag is
1906 B925              * set by add_fst when the High Sierra FST is added, and the iso_fst_header is
1907 B925              * updated at the same time by copying the High Sierra FST header (up to the
1908 B925              * name length) onto it...
1909 B925              *
1910 B925
1911 B925 00 00        hs_fst_flag DC W:0000                   ;1 = High Sierra FST loaded.
1912 B927                                                      ;Set by add_fst.
1913 B927
1914 B927 46 53 54 20  iso_fst_header DC B:'FST '              ;Load identification (4 bytes).
1915 B92B 00 00 00 00           DC L:00000000                  ;Entry point for application calls.
1916 B92F 00 00 00 00           DC L:00000000                  ;Entry point for system calls.
1917 B933 0C 00        iso_fst_id DC W:$000C                   ;ISO 9660 ID.
1918 B935 00 98                 DC W:$9800                     ;Flags: uppercase, clear msb.,read-only
1919 B937 01 82                 DC W:$8201                     ;Version 2.01, development
1920 B939 00 08                 DC W:$800                      ;Normal block size.   (2k)
1921 B93B 00 78 05 00           DC L:$57800                    ;Maximum blocks/volume. (700Mb)
1922 B93F 04 00 00 00           DC L:4                         ;Minimum blocks/volume. (8k)
1923 B943 00 78 BF 2B           DC L:$2bbf7800                 ;Maximum file size.   (699.97Mb)
1924 B947 00 00 00 00           DC L:00000000                  ;Reserved.
1925 B94B 08                    DC B:8                         ;Length of FST name.
1926 B94C 49 53 4F 20           DC B:'ISO 9660'                ;Text of FST name.
1927 B954              *
1928 B954              * The following data is used in the expand_path call to simulate a volume call
1929 B954              * so we can return the volume name when a device name/number begins the path...
1930 B954              *
1931 B954 02 00        volume_parms DC W:2                     ;Pcount.
1932 B956 60 B9 00 00           DC L:device_name               ;Pointer to device name.
1933 B95A 5E B9 00 00           DC L:volume_name               ;Pointer to volume name output.
1934 B95E
1935 B95E 32 00        volume_name DC W:50                     		;Length of output buffer.
1936 B960 07 06 00 53  device_name DS B:48                     		;Input AND output buffer.
1937 B990
1938 B990 00 00        dev_name_length DC W:0000               		;Temp storage for name length.
1939 B992 00 00        case_mask2 DC W:0000                    		;Mask for volume name copy.
1940 B994
1941 B994              *
1942 B994              * The following are state variables for the get_ref_num call...
1943 B994              *
1944 B994 00 00        fork_num DC W:0000                      ;0 = data, 1 = resource.
1945 B996 00 00        case_sense DC W:0000                    ;0 = insensitive, 1 = sensitive
1946 B998 00 00        displacement DC W:0000                  ;0 = count 'em, else find Nth.
1947 B99A 00 00        fcr_index DC W:0000                     ;Current FCR index.
1948 B99C 00 00        found_count DC W:0000                   ;Count of matching paths.
1949 B99E
1950 B99E              *
1951 B99E              * The following variable indicates whether or not the interrupt_patch is
1952 B99E              * currently installed in the main interrupt vector...
1953 B99E              *
1954 B99E 00 00        patch_state DC W:0000                   ;0=not installed, 1=installed
1955 B9A0
1956 B9A0              *
1957 B9A0              * The following data came from call_proc_data...
1958 B9A0              *
1959 B9A0
1960 B9A0                       Export num,class               ;for use by Init Mgr
1961 B9A0 0C 00        num      DC W:0000                      ;2 * primary call number
1962 B9A2 02 00        class    DC W:0000                      ;2 * subclass number
1963 B9A4 04 00        type     DC W:0000                      ;2 * call type
1964 B9A6 D1 D0        script_start DC W:0000                  ;pointer to beginning of call's script
1965 B9A8 D6 D0        script_current DC W:0000                ;pointer to current entry in script
1966 B9AA
1967 B9AA                       entry save_script_start
1968 B9AA 00 00        save_script_start DC W:0000             ;used to save script start around rename_preamble
1969 B9AC
1970 B9AC F4 BF        save_s   DC W:0000                      ;save value of S before calling FST
1971 B9AE
1972 B9AE 01 00        xlate_count DC W:0000                   ;during pathname translation, this
1973 B9B0                                                      ;...variable indicates whether the
1974 B9B0                                                      ;...first, second, etc. pathname in the
1975 B9B0                                                      ;...given parameter block is being
1976 B9B0                                                      ;...translated
1977 B9B0 00 00        xlate_type DC W:0000                    ;translation type
1978 B9B2                                                      ;$0000=translation for 'normal' call
1979 B9B2                                                      ;$0001=translation for set_prefix call
1980 B9B2
1981 B9B2 07 00        cont_offset DC W:0000                   ;temporary value indicating where to
1982 B9B4                                                      ;continue processing a pathname after
1983 B9B4                                                      ;calling another procedure
1984 B9B4 14 00        str_len  DC W:0000                      ;string length of pathname or part of
1985 B9B6                                                      ;pathname during pathname translation
1986 B9B6
1987 B9B6 FF FF        prefix_number DC W:0000                 ;prefix number determined from prefix
1988 B9B8                                                      ;designator
1989 B9B8 00 00        default_prefix DC W:0000                ;default prefix number to be used in
1990 B9BA                                                      ;xlate_path when it processes a partial
1991 B9BA                                                      ;pathname without a prefix designator
1992 B9BA
1993 B9BA 00 00        fstError DC W:0000                      ;error code returned by FST deemed most
1994 B9BC                                                      ;...likely to handle the call
1995 B9BC 00 00        first_fst DC W:0000                     ;FST table index of FST deemed most
1996 B9BE                                                      ;...likely to handle the call. It is
1997 B9BE                                                      ;...called before any other FST.
1998 B9BE 4B 04 04 00  volname_vp DC L:00000000                ;temporary vp to volume name used by
1999 B9C2                                                      ;...do_type_2
2000 B9C2 00 00 00 00  volname_ptr DC L:00000000               ;temporary ptr to volume name used by
2001 B9C6                                                      ;...do_type_2
2002 B9C6 00 00 00 00  v_ptr1   DC L:00000000                  ;temporary virtual pointers used during
2003 B9CA 00 00 00 00  v_ptr2   DC L:00000000                  ;...pathname translation
2004 B9CE                       entry path1_v_ptr              ;used only during ChangePath
2005 B9CE 00 00 00 00  path1_v_ptr DS L:1
2006 B9D2
2007 B9D2 0C 00        partial_len DC W:0000                   ;length of partial pathname during
2008 B9D4                                                      ;pathname translation
2009 B9D4 3A           save_control DC B:00                    ;controlling separator for the pathname
2010 B9D5 7F           char_mask DC B:00                       ;mask for all pathname characters
2011 B9D6 14 EA 00 00  handler_addr DC L:00000000              ;address of routine that processes the
2012 B9DA                                                      ;current system call
2013 B9DA 00 00        s_level  DC W:0000                      ;level variable used to communicate
2014 B9DC                                                      ;...between the do_type_6 and do_type_3
2015 B9DC
2016 B9DC                       entry dev_status
2017 B9DC 10 80        dev_status DC W:0000                    ;used for result of device status call
2018 B9DE
2019 B9DE                       entry do_runq
2020 B9DE 00 00        do_runq  DC W:0                         ;flag set by s_mount_msg to use a
2021 B9E0                                                      ;  RunQ handler to recognize a disk
2022 B9E0                                                      ;  insertion.
2023 B9E0                       entry io_flag
2024 B9E0 00 00        io_flag  DC W:0                         ;bit flags for fast character I/O
2025 B9E2
2026 B9E2                       entry gsos_id
2027 B9E2 08 31        gsos_id  DC W:0
2028 B9E4
2029 B9E4                       entry SizeRect
2030 B9E4 00 00 00 00  SizeRect DC W:0,0,200,640               ;RECT used by os_shutdown
2031 B9EC
2032 B9EC                       end_proc 
2033 B9EC
2034 B9EC                       eject 
2035 B9EC              *******************************************************************************
2036 B9EC              *
2037 B9EC              * End miscellaneous segment: $00B300-globals_end (~$00B9EE)
2038 B9EC              *
2039 B9EC              *******************************************************************************
